/*
 * Decompiled with CFR 0.152.
 */
package me.angel.tridentrain;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import me.angel.tridentrain.CustomHealingTntEntity;
import me.angel.tridentrain.CustomTntEntity;
import me.angel.tridentrain.Tridentrain;
import me.angel.tridentrain.config.TridentRainConfig;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1540;
import net.minecraft.class_1541;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3730;

public class TntRain {
    private static final Set<UUID> spawnedTntEntities = new HashSet<UUID>();

    public static void spawnTntAroundPlayer(class_3218 world, class_3222 player, TridentRainConfig config) {
        Random random = new Random();
        int tntPerTick = TntRain.calculateTntSpawnRate(config);
        for (int i = 0; i < tntPerTick; ++i) {
            double x = player.method_23317() + (random.nextDouble() * 2.0 - 1.0) * config.getSpawnRadius();
            double y = player.method_23318() + (double)config.getFallHeight();
            double z = player.method_23321() + (random.nextDouble() * 2.0 - 1.0) * config.getSpawnRadius();
            TntRain.spawnTntEntity(world, x, y, z, config);
        }
    }

    private static int calculateTntSpawnRate(TridentRainConfig config) {
        int intensityLevel = config.getCurrentIntensityLevel();
        Random random = new Random();
        if (intensityLevel <= 3) {
            return random.nextFloat() < 0.5f ? 1 : 0;
        }
        if (intensityLevel <= 6) {
            return random.nextFloat() < 0.7f ? 1 : 0;
        }
        return random.nextFloat() < 0.8f ? 1 : 0;
    }

    public static int getTntSpawnRate(TridentRainConfig config) {
        return TntRain.calculateTntSpawnRate(config);
    }

    public static void spawnTntEntity(class_3218 world, double x, double y, double z, TridentRainConfig config) {
        int minSpawnY;
        class_2338 playerPos = new class_2338((int)x, (int)(y - (double)config.getFallHeight()), (int)z);
        class_2338 spawnPos = null;
        int MIN_SAFE_HEIGHT = 3;
        for (int checkY = minSpawnY = playerPos.method_10264() + 3; checkY <= playerPos.method_10264() + config.getFallHeight(); ++checkY) {
            class_2338 checkPos = new class_2338((int)x, checkY, (int)z);
            class_2680 checkState = world.method_8320(checkPos);
            if (checkState.method_26215()) {
                spawnPos = checkPos;
                continue;
            }
            if (spawnPos != null) break;
        }
        if (spawnPos == null) {
            spawnPos = new class_2338((int)x, (int)y, (int)z);
        }
        TntVariant variant = TntRain.getRandomTntVariant(config);
        switch (variant.ordinal()) {
            case 0: {
                TntRain.spawnNormalTnt(world, spawnPos, config);
                break;
            }
            case 1: {
                TntRain.spawnDudTnt(world, spawnPos, config);
                break;
            }
            case 2: {
                TntRain.spawnPlacedTnt(world, spawnPos, config);
                break;
            }
            case 3: {
                TntRain.spawnDelayedTnt(world, spawnPos, config);
                break;
            }
            case 4: {
                TntRain.spawnDelayedDudTnt(world, spawnPos, config);
                break;
            }
            case 5: {
                TntRain.spawnHealingTnt(world, spawnPos, config);
            }
        }
    }

    private static void spawnNormalTnt(class_3218 world, class_2338 pos, TridentRainConfig config) {
        try {
            class_1541 tnt = (class_1541)class_1299.field_6063.method_47821(world, pos, class_3730.field_16467);
            if (tnt != null) {
                Random random = new Random();
                int fuseTime = 60 + random.nextInt(101);
                tnt.method_6967(fuseTime);
                spawnedTntEntities.add(tnt.method_5667());
                tnt.method_18800(random.nextDouble() * 0.2 - 0.1, -0.3 - random.nextDouble() * 0.2, random.nextDouble() * 0.2 - 0.1);
                Tridentrain.LOGGER.debug("Spawned normal TNT with {} tick fuse", (Object)fuseTime);
            }
        }
        catch (Exception e) {
            Tridentrain.LOGGER.error("Error spawning normal TNT: {}", (Object)e.getMessage());
        }
    }

    private static void spawnDudTnt(class_3218 world, class_2338 pos, TridentRainConfig config) {
        try {
            CustomTntEntity tnt = new CustomTntEntity((class_1299<? extends class_1541>)class_1299.field_6063, (class_1937)world);
            tnt.method_5814((double)pos.method_10263() + 0.5, pos.method_10264(), (double)pos.method_10260() + 0.5);
            tnt.setDud(true);
            Random random = new Random();
            int fuseTime = 60 + random.nextInt(101);
            tnt.method_6967(fuseTime);
            spawnedTntEntities.add(tnt.method_5667());
            tnt.method_18800(random.nextDouble() * 0.2 - 0.1, -0.3 - random.nextDouble() * 0.2, random.nextDouble() * 0.2 - 0.1);
            world.method_8649((class_1297)tnt);
            Tridentrain.LOGGER.debug("Spawned dud TNT with {} tick fuse", (Object)fuseTime);
        }
        catch (Exception e) {
            Tridentrain.LOGGER.error("Error spawning dud TNT: {}", (Object)e.getMessage());
        }
    }

    private static void spawnPlacedTnt(class_3218 world, class_2338 pos, TridentRainConfig config) {
        try {
            class_2680 tntState = class_2246.field_10375.method_9564();
            class_1540 fallingTnt = class_1540.method_40005((class_1937)world, (class_2338)pos, (class_2680)tntState);
            if (fallingTnt != null) {
                fallingTnt.field_7193 = false;
                fallingTnt.field_7192 = 1;
                Random random = new Random();
                fallingTnt.method_18800(random.nextDouble() * 0.2 - 0.1, -0.3 - random.nextDouble() * 0.2, random.nextDouble() * 0.2 - 0.1);
                Tridentrain.LOGGER.debug("Spawned placed TNT block");
            }
        }
        catch (Exception e) {
            Tridentrain.LOGGER.error("Error spawning placed TNT: {}", (Object)e.getMessage());
        }
    }

    private static void spawnDelayedTnt(class_3218 world, class_2338 pos, TridentRainConfig config) {
        try {
            class_1541 tnt = (class_1541)class_1299.field_6063.method_47821(world, pos, class_3730.field_16467);
            if (tnt != null) {
                Random random = new Random();
                int fuseTime = 300 + random.nextInt(301);
                tnt.method_6967(fuseTime);
                spawnedTntEntities.add(tnt.method_5667());
                tnt.method_18800(random.nextDouble() * 0.2 - 0.1, -0.3 - random.nextDouble() * 0.2, random.nextDouble() * 0.2 - 0.1);
                Tridentrain.LOGGER.debug("Spawned delayed TNT with {} tick fuse", (Object)fuseTime);
            }
        }
        catch (Exception e) {
            Tridentrain.LOGGER.error("Error spawning delayed TNT: {}", (Object)e.getMessage());
        }
    }

    private static void spawnDelayedDudTnt(class_3218 world, class_2338 pos, TridentRainConfig config) {
        try {
            CustomTntEntity tnt = new CustomTntEntity((class_1299<? extends class_1541>)class_1299.field_6063, (class_1937)world);
            tnt.method_5814((double)pos.method_10263() + 0.5, pos.method_10264(), (double)pos.method_10260() + 0.5);
            Random random = new Random();
            int fuseTime = 300 + random.nextInt(301);
            tnt.method_6967(fuseTime);
            tnt.setDud(true);
            spawnedTntEntities.add(tnt.method_5667());
            tnt.method_18800(random.nextDouble() * 0.2 - 0.1, -0.3 - random.nextDouble() * 0.2, random.nextDouble() * 0.2 - 0.1);
            world.method_8649((class_1297)tnt);
            Tridentrain.LOGGER.debug("Spawned delayed dud TNT with {} tick fuse", (Object)fuseTime);
        }
        catch (Exception e) {
            Tridentrain.LOGGER.error("Error spawning delayed dud TNT: {}", (Object)e.getMessage());
        }
    }

    private static void spawnHealingTnt(class_3218 world, class_2338 pos, TridentRainConfig config) {
        try {
            CustomHealingTntEntity tnt = new CustomHealingTntEntity((class_1299<? extends class_1541>)class_1299.field_6063, (class_1937)world);
            tnt.method_5814((double)pos.method_10263() + 0.5, pos.method_10264(), (double)pos.method_10260() + 0.5);
            Random random = new Random();
            int fuseTime = 80 + random.nextInt(81);
            tnt.method_6967(fuseTime);
            spawnedTntEntities.add(tnt.method_5667());
            tnt.method_18800(random.nextDouble() * 0.2 - 0.1, -0.3 - random.nextDouble() * 0.2, random.nextDouble() * 0.2 - 0.1);
            world.method_8649((class_1297)tnt);
            Tridentrain.LOGGER.debug("Spawned healing TNT with {} tick fuse", (Object)fuseTime);
        }
        catch (Exception e) {
            Tridentrain.LOGGER.error("Error spawning healing TNT: {}", (Object)e.getMessage());
        }
    }

    private static TntVariant getRandomTntVariant(TridentRainConfig config) {
        ArrayList<TntVariant> weightedVariants = new ArrayList<TntVariant>();
        if (config.isNormalTntEnabled()) {
            for (int i = 0; i < 8; ++i) {
                weightedVariants.add(TntVariant.NORMAL);
            }
        }
        if (config.isDudTntEnabled()) {
            weightedVariants.add(TntVariant.DUD);
        }
        if (config.isPlacedTntEnabled()) {
            weightedVariants.add(TntVariant.PLACED);
        }
        if (config.isDelayedTntEnabled()) {
            weightedVariants.add(TntVariant.DELAYED);
        }
        if (config.isDelayedDudTntEnabled()) {
            weightedVariants.add(TntVariant.DELAYED_DUD);
        }
        if (config.isHealingTntEnabled()) {
            weightedVariants.add(TntVariant.HEALING);
        }
        if (weightedVariants.isEmpty()) {
            return TntVariant.NORMAL;
        }
        Random random = new Random();
        return (TntVariant)((Object)weightedVariants.get(random.nextInt(weightedVariants.size())));
    }

    public static boolean isModSpawnedTnt(class_1297 entity) {
        return spawnedTntEntities.contains(entity.method_5667());
    }

    public static void removeTntFromTracking(UUID uuid) {
        spawnedTntEntities.remove(uuid);
    }

    public static void handleDudTntExplosion(class_3218 world, class_2338 pos) {
        Tridentrain.LOGGER.debug("Dud TNT exploded at {}", (Object)pos);
    }

    public static enum TntVariant {
        NORMAL("Normal TNT"),
        DUD("Dud TNT"),
        PLACED("Placed TNT"),
        DELAYED("Delayed TNT"),
        DELAYED_DUD("Delayed Dud TNT"),
        HEALING("Healing TNT");

        private final String displayName;

        private TntVariant(String displayName) {
            this.displayName = displayName;
        }

        public String getDisplayName() {
            return this.displayName;
        }
    }
}

